// $Id$
// balade_nature

var text = null;
var spot = null;
var box = null;
var boxProperty = '';


window.addEvent('domready', function(){
    // Tooltips
    (function initialize() {
        $$(".pdocImagePulse").each(function(pulse) {
            var mainImg  = pulse.getParent().getElement("img");
            var pulseImg = pulse.getElement("img");
            var tooltip  = $(pulse.get('id')+"t");
            mainImg.setStyle("max-width", "none");
            var pulseWidth  = 100 * pulseImg.getSize().x / mainImg.getSize().x;
            var pulseHeight = 100 * pulseImg.getSize().y / mainImg.getSize().y;
            var mainImgRealWidth = mainImg.getSize().x;

            pulse.setStyles({
                "width": pulseWidth + "%", "height": pulseHeight + "%",
                "left": (pulse.getStyle("left").toFloat() - pulseWidth/2) + "%",
                "top":  (pulse.getStyle("top").toFloat() - pulseHeight/2) + "%"
            });
            pulseImg.setStyle("width", "100%");
            mainImg.setStyle("max-width", "100%");
            mainImg.getParent().setStyle("max-width", "100%");

            var fontSize = tooltip.getStyle("font-size").toFloat();
            tooltip.setStyles({
                "opacity": 0, "display": "block",
                "font-size": (fontSize * mainImg.getSize().x / mainImgRealWidth)
                    + tooltip.getStyle("font-size").replace(fontSize, "")
            });
            
            var tooltipImg = tooltip.getElement("img");
            if (tooltipImg) {
                tooltip.setStyle(
                    "width", (100 * tooltipImg.getSize().x / mainImgRealWidth) + "%");
                tooltipImg.setStyle("width", "100%");
            }
        });

        $$(".pdocImagePulse").addEvent("click", function() {
            var pulse   = this;
            var tooltip = $(this.get('id')+"t");
            pulse.setStyle("display", "none");
            tooltip.tween("opacity", 1);
            (function() {
                tooltip.tween("opacity", 0);
                pulse.setStyle("display", "block");
            }).delay(12000);
        });
        
        $$(".pdocImageTooltip").addEvent("click", function() {
            this.tween("opacity", 0);
            $(this.get('id').substr(0, this.get('id').length-1))
                .setStyle("display", "block");
        });
    }).delay(50);
     
    // Effect: glow
    var effectGlow = $("effectGlow");
    if (effectGlow) {
        text = $("effectGlowText");
        spot = $("effectGlowSpot");
        box = $("effectGlowBox")
        if (typeof box.style.webkitBoxShadow == 'string') {
            boxProperty = 'webkitBoxShadow';
        } else if (typeof box.style.MozBoxShadow == 'string') {
            boxProperty = 'MozBoxShadow';
        } else if (typeof box.style.boxShadow == 'string') {
            boxProperty = 'boxShadow';
        }

        if (text && spot && box) {
            effectGlow.onmousemove = onMouseMove;
            effectGlow.ontouchmove = function (e) {
                e.preventDefault();
                e.stopPropagation();
                onMouseMove({clientX: e.touches[0].clientX, clientY: e.touches[0].clientY});
            }
        }
    }
});


function onMouseMove(e) {
    if (typeof e === 'undefined' || typeof e.clientX === 'undefined') {
        return;
    }
    
    var xm = (e.clientX - Math.floor(window.innerWidth / 2)) * 0.4;
    var ym = (e.clientY - Math.floor(window.innerHeight / 3)) * 0.4;
    var d = Math.round(Math.sqrt(xm*xm + ym*ym) / 5);
    text.style.textShadow = -xm + 'px ' + -ym + 'px ' + (d + 10) + 'px black';
    
    if (boxProperty) {
        box.style[boxProperty] = '0 ' + -ym + 'px ' + (d + 30) + 'px black';
    }
    
    xm = e.clientX - Math.floor(window.innerWidth / 2);
    ym = e.clientY - Math.floor(window.innerHeight / 2);
    spot.style.backgroundPosition = xm + 'px ' + ym + 'px';
}

