// $Id$
// balade_nature

/*global $: true */
/*global $$: true */

var text = null;
var spot = null;
var box = null;
var boxProperty = '';


window.addEvent('domready', function(){
    // Hotspots
    (function initialize() {
        $$(".pdocHotspot").each(function(hotspot) {
            var spot = $(hotspot.get('id') + "s");
            var scenario = hotspot.getElement("span");
            if (spot && scenario) {
                hotspot.addEvent("click", function() {
                    var spot = $(this.get('id') + "s");
                    if (spot.getChildren("img")) {
                        spot.setStyles({"opacity": 1, "display": "block"});
                    } else {
                        spot.setStyles({"opacity": 0, "display": "block"});
                        spot.tween("opacity", 1);
                    }
                    this.setStyle("display", "none");
                    (function() {
                        spot.setStyle("display", "none");
                        hotspot.setStyle("display", "block");
                    }).delay(12000);
                });

                spot.addEvent("click", function() {
                    this.setStyle("display", "none");
                    $(this.get('id').substring(0, this.get('id').length-1))
                        .setStyle("display", "block");
                });
            }
        });
    }).delay(100);
     
    // Effect: glow
    var effectGlow = $("effectGlow");
    if (effectGlow) {
        text = $("effectGlowText");
        spot = $("effectGlowSpot");
        box = $("effectGlowBox")
        if (typeof box.style.webkitBoxShadow == 'string') {
            boxProperty = 'webkitBoxShadow';
        } else if (typeof box.style.MozBoxShadow == 'string') {
            boxProperty = 'MozBoxShadow';
        } else if (typeof box.style.boxShadow == 'string') {
            boxProperty = 'boxShadow';
        }

        if (text && spot && box) {
            effectGlow.onmousemove = onMouseMove;
            effectGlow.ontouchmove = function (e) {
                e.preventDefault();
                e.stopPropagation();
                onMouseMove({clientX: e.touches[0].clientX, clientY: e.touches[0].clientY});
            };
        }
    }
});


function onMouseMove(e) {
    if (typeof e === 'undefined' || typeof e.clientX === 'undefined') {
        return;
    }
    
    var xm = (e.clientX - Math.floor(window.innerWidth / 2)) * 0.4;
    var ym = (e.clientY - Math.floor(window.innerHeight / 3)) * 0.4;
    var d = Math.round(Math.sqrt(xm*xm + ym*ym) / 5);
    text.style.textShadow = -xm + 'px ' + -ym + 'px ' + (d + 10) + 'px black';
    
    if (boxProperty) {
        box.style[boxProperty] = '0 ' + -ym + 'px ' + (d + 30) + 'px black';
    }
    
    xm = e.clientX - Math.floor(window.innerWidth / 2);
    ym = e.clientY - Math.floor(window.innerHeight / 2);
    spot.style.backgroundPosition = xm + 'px ' + ym + 'px';
}

