// $Id$
// balade_nature

var text = null;
var spot = null;
var box = null;
var boxProperty = '';


window.addEvent('domready', function(){
    // Hotspots
    (function initialize() {
        var scenario;
        var content;
        $$(".pdocHotspot").each(function(hotspot) {
            scenario = hotspot.getElement("span");
            content = $(hotspot.get('id').replace("x", "z"))
            if (scenario && content) {
                
                hotspot.addEvent("click", function() {
                    var content = $(this.get('id').replace("x", "z"));
                    content.setStyles({"opacity": 0, "display": "block"});
                    this.setStyle("display", "none");
                    content.tween("opacity", 1);
                    (function() {
                        content.setStyle("display", "none");
                        hotspot.setStyle("display", "block");
                    }).delay(12000);
                });

                content.addEvent("click", function() {
                    this.setStyle("display", "none");
                    $(this.get('id').replace("z", "x"))
                        .setStyle("display", "block");
                });
            }
        });
    }).delay(100);
     
    // Effect: glow
    var effectGlow = $("effectGlow");
    if (effectGlow) {
        text = $("effectGlowText");
        spot = $("effectGlowSpot");
        box = $("effectGlowBox")
        if (typeof box.style.webkitBoxShadow == 'string') {
            boxProperty = 'webkitBoxShadow';
        } else if (typeof box.style.MozBoxShadow == 'string') {
            boxProperty = 'MozBoxShadow';
        } else if (typeof box.style.boxShadow == 'string') {
            boxProperty = 'boxShadow';
        }

        if (text && spot && box) {
            effectGlow.onmousemove = onMouseMove;
            effectGlow.ontouchmove = function (e) {
                e.preventDefault();
                e.stopPropagation();
                onMouseMove({clientX: e.touches[0].clientX, clientY: e.touches[0].clientY});
            }
        }
    }
});


function onMouseMove(e) {
    if (typeof e === 'undefined' || typeof e.clientX === 'undefined') {
        return;
    }
    
    var xm = (e.clientX - Math.floor(window.innerWidth / 2)) * 0.4;
    var ym = (e.clientY - Math.floor(window.innerHeight / 3)) * 0.4;
    var d = Math.round(Math.sqrt(xm*xm + ym*ym) / 5);
    text.style.textShadow = -xm + 'px ' + -ym + 'px ' + (d + 10) + 'px black';
    
    if (boxProperty) {
        box.style[boxProperty] = '0 ' + -ym + 'px ' + (d + 30) + 'px black';
    }
    
    xm = e.clientX - Math.floor(window.innerWidth / 2);
    ym = e.clientY - Math.floor(window.innerHeight / 2);
    spot.style.backgroundPosition = xm + 'px ' + ym + 'px';
}

